"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const db_1 = require("../config/db");
async function run() {
    try {
        const conn = await db_1.pool.getConnection();
        try {
            await conn.query("ALTER TABLE company_documents ADD COLUMN type VARCHAR(50) NULL AFTER url");
            console.log("Added type column to company_documents");
        }
        catch (e) {
            if (e.code === 'ER_DUP_FIELDNAME') {
                console.log("Column type already exists");
            }
            else {
                console.error("Failed to alter table:", e);
            }
        }
        finally {
            conn.release();
            process.exit(0);
        }
    }
    catch (err) {
        console.error("Connection failed:", err);
        process.exit(1);
    }
}
run();
