"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const fs_1 = require("fs");
const path_1 = require("path");
const promise_1 = __importDefault(require("mysql2/promise"));
const db_1 = require("../config/db");
const env_1 = require("../config/env");
async function run() {
    const sqlPath = (0, path_1.join)(process.cwd(), 'seed', 'schema.sql');
    const sql = (0, fs_1.readFileSync)(sqlPath, 'utf-8');
    // Ensure DB exists first
    const adminConn = await promise_1.default.createConnection({
        host: env_1.env.dbHost,
        port: env_1.env.dbPort,
        user: env_1.env.dbUser,
        password: env_1.env.dbPassword,
        multipleStatements: true,
    });
    await adminConn.query(`CREATE DATABASE IF NOT EXISTS \`${env_1.env.dbName}\` CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci`);
    await adminConn.end();
    const conn = await db_1.pool.getConnection();
    try {
        await conn.query(sql);
        console.log('Schema migration completed');
    }
    finally {
        conn.release();
        process.exit(0);
    }
}
run().catch(err => {
    console.error(err);
    process.exit(1);
});
