"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const fs_1 = require("fs");
const path_1 = require("path");
const db_1 = require("../config/db");
async function run() {
    const sqlPath = (0, path_1.join)(process.cwd(), 'seed', 'seed.sql');
    const sql = (0, fs_1.readFileSync)(sqlPath, 'utf-8');
    const conn = await db_1.pool.getConnection();
    try {
        await conn.query(sql);
        console.log('Seed data inserted');
    }
    finally {
        conn.release();
        process.exit(0);
    }
}
run().catch(err => {
    console.error(err);
    process.exit(1);
});
