"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const authMiddleware_1 = require("../middleware/authMiddleware");
const usersRepo_1 = require("../repositories/usersRepo");
const router = (0, express_1.Router)();
router.get('/', authMiddleware_1.requireAuth, (0, authMiddleware_1.requireRole)('Super Admin', 'Admin'), async (_req, res) => {
    const users = await (0, usersRepo_1.listUsers)();
    res.json(users.map(u => ({ id: String(u.uuid), name: u.name, email: u.email, role: u.role })));
});
router.post('/', authMiddleware_1.requireAuth, (0, authMiddleware_1.requireRole)('Super Admin'), async (req, res) => {
    try {
        const { uuid } = await (0, usersRepo_1.createUser)(req.body);
        res.json({ id: uuid });
    }
    catch (error) {
        console.error(error);
        res.status(500).json({ error: 'Failed to create user' });
    }
});
router.put('/:id', authMiddleware_1.requireAuth, (0, authMiddleware_1.requireRole)('Super Admin'), async (req, res) => {
    try {
        const success = await (0, usersRepo_1.updateUser)(req.params.id, req.body);
        res.json({ ok: success });
    }
    catch (error) {
        console.error(error);
        res.status(500).json({ error: 'Failed to update user' });
    }
});
router.delete('/:id', authMiddleware_1.requireAuth, (0, authMiddleware_1.requireRole)('Super Admin'), async (req, res) => {
    try {
        const success = await (0, usersRepo_1.deleteUser)(req.params.id);
        res.json({ ok: success });
    }
    catch (error) {
        console.error(error);
        res.status(500).json({ error: 'Failed to delete user' });
    }
});
exports.default = router;
