"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const authMiddleware_1 = require("../middleware/authMiddleware");
const db_1 = require("../config/db");
const router = (0, express_1.Router)();
router.get('/overview', authMiddleware_1.requireAuth, async (_req, res) => {
    const [[leadByStatus]] = await db_1.pool.query(`SELECT status, COUNT(*) as count FROM leads GROUP BY status`);
    const [leadByService] = await db_1.pool.query(`SELECT service, COUNT(*) as count FROM leads GROUP BY service`);
    const [pipeline] = await db_1.pool.query(`SELECT status, COUNT(*) as count FROM leads WHERE status IN ('New','Contacted','Converted') GROUP BY status`);
    const [overdueCompanies] = await db_1.pool.query(`SELECT uuid, name, renewal_date FROM companies WHERE renewal_date < CURDATE() ORDER BY renewal_date ASC LIMIT 50`);
    const [dueSoonCompanies] = await db_1.pool.query(`SELECT uuid, name, renewal_date FROM companies WHERE renewal_date BETWEEN CURDATE() AND DATE_ADD(CURDATE(), INTERVAL 30 DAY) ORDER BY renewal_date ASC LIMIT 50`);
    const [[loanEligibleCount]] = await db_1.pool.query(`SELECT COUNT(*) as count FROM companies WHERE is_loan_eligible=1`);
    const [taskByStatus] = await db_1.pool.query(`SELECT status, COUNT(*) as count FROM tasks GROUP BY status`);
    res.json({
        leadCountsByStatus: leadByStatus || [],
        leadCountsByService: leadByService || [],
        pipelineSummary: pipeline || [],
        companiesOverdueRenewals: overdueCompanies || [],
        companiesDueNext30Days: dueSoonCompanies || [],
        loanEligibleCompaniesCount: loanEligibleCount?.count ?? 0,
        taskCountsByStatus: taskByStatus || [],
    });
});
exports.default = router;
