"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const authMiddleware_1 = require("../middleware/authMiddleware");
const notificationsRepo_1 = require("../repositories/notificationsRepo");
const router = (0, express_1.Router)();
router.get('/', authMiddleware_1.requireAuth, async (req, res) => {
    const r = req;
    const rows = await (0, notificationsRepo_1.listNotificationsForUser)(r.user.id);
    res.json(rows.map(n => ({ id: String(n.uuid), title: n.title, message: n.message, type: n.type, timestamp: n.timestamp, read: !!n.is_read, link: n.link || undefined })));
});
router.patch('/:uuid/read', authMiddleware_1.requireAuth, async (req, res) => {
    const ok = await (0, notificationsRepo_1.markNotificationRead)(req.params.uuid);
    if (!ok)
        return res.status(404).json({ message: 'Not found' });
    res.json({ ok: true });
});
router.patch('/read-all', authMiddleware_1.requireAuth, async (req, res) => {
    const r = req;
    await (0, notificationsRepo_1.markAllRead)(r.user.id);
    res.json({ ok: true });
});
exports.default = router;
