"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.listTasks = listTasks;
exports.getTaskByUuid = getTaskByUuid;
exports.createTask = createTask;
exports.updateTask = updateTask;
exports.patchTaskStatus = patchTaskStatus;
exports.deleteTask = deleteTask;
const db_1 = require("../config/db");
const uuid_1 = require("uuid");
async function listTasks(filters) {
    const where = [];
    const params = [];
    if (filters.status) {
        where.push('status = ?');
        params.push(filters.status);
    }
    if (filters.ownerId) {
        where.push('owner_id = ?');
        params.push(filters.ownerId);
    }
    if (filters.priority) {
        where.push('priority = ?');
        params.push(filters.priority);
    }
    if (filters.search) {
        where.push('(title LIKE ? OR description LIKE ?)');
        params.push(`%${filters.search}%`, `%${filters.search}%`);
    }
    if (filters.dueFrom) {
        where.push('due_date >= ?');
        params.push(filters.dueFrom);
    }
    if (filters.dueTo) {
        where.push('due_date <= ?');
        params.push(filters.dueTo);
    }
    const sql = `SELECT t.*, u.name AS owner_name, u.uuid AS owner_uuid FROM tasks t LEFT JOIN users u ON t.owner_id=u.id` + (where.length ? ` WHERE ${where.join(' AND ')}` : '') + ' ORDER BY t.due_date ASC, t.created_at DESC LIMIT 200';
    const [rows] = await db_1.pool.query(sql, params);
    return rows;
}
async function getTaskByUuid(uuid) {
    const [rows] = await db_1.pool.query('SELECT t.*, u.name AS owner_name, u.uuid AS owner_uuid FROM tasks t LEFT JOIN users u ON t.owner_id=u.id WHERE t.uuid=? LIMIT 1', [uuid]);
    return rows[0] || null;
}
async function createTask(payload) {
    const uuid = (0, uuid_1.v4)();
    let ownerIdInt = payload.ownerId;
    if (typeof payload.ownerId === 'string' && payload.ownerId.length > 10) {
        const [rows] = await db_1.pool.query('SELECT id FROM users WHERE uuid = ?', [payload.ownerId]);
        if (rows.length > 0) {
            ownerIdInt = rows[0].id;
        }
    }
    await db_1.pool.query('INSERT INTO tasks (uuid, title, description, due_date, priority, status, type, owner_id, related_company_id, related_lead_id, related_entity_display) VALUES (?,?,?,?,?,?,?,?,?,?,?)', [uuid, payload.title, payload.description || null, payload.dueDate || null, payload.priority, payload.status, payload.type || null, ownerIdInt, payload.relatedCompanyId || null, payload.relatedLeadId || null, payload.relatedEntity || null]);
    return uuid;
}
async function updateTask(uuid, payload) {
    let ownerIdInt = payload.ownerId;
    if (typeof payload.ownerId === 'string' && payload.ownerId.length > 10) {
        const [rows] = await db_1.pool.query('SELECT id FROM users WHERE uuid = ?', [payload.ownerId]);
        if (rows.length > 0) {
            ownerIdInt = rows[0].id;
        }
    }
    const [res] = await db_1.pool.query('UPDATE tasks SET title=?, description=?, due_date=?, priority=?, status=?, type=?, owner_id=?, related_company_id=?, related_lead_id=?, related_entity_display=? WHERE uuid=?', [payload.title, payload.description || null, payload.dueDate || null, payload.priority, payload.status, payload.type || null, ownerIdInt, payload.relatedCompanyId || null, payload.relatedLeadId || null, payload.relatedEntity || null, uuid]);
    return res.affectedRows > 0;
}
async function patchTaskStatus(uuid, status) {
    const [res] = await db_1.pool.query('UPDATE tasks SET status=? WHERE uuid=?', [status, uuid]);
    return res.affectedRows > 0;
}
async function deleteTask(uuid) {
    const [res] = await db_1.pool.query('DELETE FROM tasks WHERE uuid=?', [uuid]);
    return res.affectedRows > 0;
}
