"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.listServices = listServices;
exports.getServiceByUuid = getServiceByUuid;
exports.createService = createService;
exports.updateService = updateService;
exports.deleteService = deleteService;
exports.listRules = listRules;
exports.addRule = addRule;
const db_1 = require("../config/db");
const uuid_1 = require("uuid");
async function listServices() {
    const [rows] = await db_1.pool.query('SELECT * FROM services ORDER BY name');
    return rows;
}
async function getServiceByUuid(uuid) {
    const [rows] = await db_1.pool.query('SELECT * FROM services WHERE uuid=? LIMIT 1', [uuid]);
    const svc = rows[0];
    if (!svc)
        return null;
    const [rules] = await db_1.pool.query('SELECT * FROM service_rules WHERE service_id=? ORDER BY trigger_days', [svc.id]);
    return { service: svc, rules: rules };
}
async function createService(payload) {
    const uuid = (0, uuid_1.v4)();
    await db_1.pool.query('INSERT INTO services (uuid, name, description, active, checklist_json) VALUES (?,?,?,?,?)', [uuid, payload.name, payload.description || null, payload.active ? 1 : 0, JSON.stringify(payload.checklist || [])]);
    return uuid;
}
async function updateService(uuid, payload) {
    const [res] = await db_1.pool.query('UPDATE services SET name=?, description=?, active=?, checklist_json=? WHERE uuid=?', [payload.name, payload.description || null, payload.active ? 1 : 0, JSON.stringify(payload.checklist || []), uuid]);
    return res.affectedRows > 0;
}
async function deleteService(uuid) {
    const [res] = await db_1.pool.query('DELETE FROM services WHERE uuid=?', [uuid]);
    return res.affectedRows > 0;
}
async function listRules(uuid) {
    const [rows] = await db_1.pool.query('SELECT id FROM services WHERE uuid=?', [uuid]);
    const svc = rows[0];
    if (!svc)
        return null;
    const [rules] = await db_1.pool.query('SELECT * FROM service_rules WHERE service_id=? ORDER BY trigger_days', [svc.id]);
    return rules;
}
async function addRule(uuid, rule) {
    const [rows] = await db_1.pool.query('SELECT id FROM services WHERE uuid=?', [uuid]);
    const svc = rows[0];
    if (!svc)
        return null;
    const [res] = await db_1.pool.query('INSERT INTO service_rules (service_id, rule_type, trigger_days, description) VALUES (?,?,?,?)', [svc.id, rule.type, rule.triggerDays, rule.description || null]);
    return res.insertId;
}
