"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.listNotificationsForUser = listNotificationsForUser;
exports.markNotificationRead = markNotificationRead;
exports.markAllRead = markAllRead;
exports.createNotification = createNotification;
const db_1 = require("../config/db");
async function listNotificationsForUser(userId) {
    const [rows] = await db_1.pool.query('SELECT * FROM notifications WHERE user_id=? ORDER BY timestamp DESC LIMIT 200', [userId]);
    return rows;
}
async function markNotificationRead(uuid) {
    const [res] = await db_1.pool.query('UPDATE notifications SET is_read=1 WHERE uuid=?', [uuid]);
    return res.affectedRows > 0;
}
async function markAllRead(userId) {
    const [res] = await db_1.pool.query('UPDATE notifications SET is_read=1 WHERE user_id=?', [userId]);
    return res.affectedRows >= 0;
}
async function createNotification(userId, title, message, type, link) {
    await db_1.pool.query('INSERT INTO notifications (uuid, user_id, title, message, type, link) VALUES (UUID(),?,?,?,?,?)', [userId, title, message, type, link || null]);
}
