"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.login = login;
exports.bootstrap = bootstrap;
exports.me = me;
const bcrypt_1 = __importDefault(require("bcrypt"));
const jsonwebtoken_1 = __importDefault(require("jsonwebtoken"));
const env_1 = require("../config/env");
const usersRepo_1 = require("../repositories/usersRepo");
async function login(req, res) {
    console.log('Login attempt:', req.body);
    const { email, password } = req.body || {};
    if (!email || !password)
        return res.status(400).json({ message: 'email and password required' });
    const user = await (0, usersRepo_1.findUserByEmail)(email);
    if (!user || !user.is_active)
        return res.status(401).json({ message: 'Invalid credentials' });
    const ok = await bcrypt_1.default.compare(password, user.password_hash);
    if (!ok)
        return res.status(401).json({ message: 'Invalid credentials' });
    const token = jsonwebtoken_1.default.sign({ id: user.id, uuid: user.uuid, role: user.role, name: user.name, email: user.email }, env_1.env.jwtSecret, { expiresIn: '12h' });
    return res.json({ token, user: { id: String(user.uuid), name: user.name, email: user.email, role: user.role } });
}
// First-run helper: allows creating the first Super Admin ONLY when there are no users.
// This avoids requiring seed data during initial cPanel deployment.
async function bootstrap(req, res) {
    const existing = await (0, usersRepo_1.countUsers)();
    if (existing > 0)
        return res.status(403).json({ message: 'Bootstrap is disabled after initial setup' });
    const { name, email, password } = req.body || {};
    if (!name || !email || !password) {
        return res.status(400).json({ message: 'name, email and password required' });
    }
    await (0, usersRepo_1.createUser)({ name, email, password, role: 'Super Admin' });
    const user = await (0, usersRepo_1.findUserByEmail)(email);
    if (!user)
        return res.status(500).json({ message: 'Failed to create user' });
    const token = jsonwebtoken_1.default.sign({ id: user.id, uuid: user.uuid, role: user.role, name: user.name, email: user.email }, env_1.env.jwtSecret, { expiresIn: '12h' });
    return res.json({ token, user: { id: String(user.uuid), name: user.name, email: user.email, role: user.role } });
}
async function me(_req, res) {
    const u = res.locals.user;
    return res.json({ user: u });
}
