"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.env = void 0;
const dotenv_1 = __importDefault(require("dotenv"));
dotenv_1.default.config();
function required(name, defaultValue) {
    const val = process.env[name] ?? defaultValue;
    if (!val)
        throw new Error(`Missing env var: ${name}`);
    return val;
}
exports.env = {
    port: parseInt(process.env.PORT || '3001', 10),
    dbHost: required('DB_HOST'),
    dbPort: parseInt(required('DB_PORT', '3306'), 10),
    dbUser: required('DB_USER'),
    dbPassword: process.env.DB_PASSWORD ?? '',
    dbName: required('DB_NAME'),
    jwtSecret: required('JWT_SECRET'),
    apiBasePath: process.env.API_BASE_PATH || '/api',
    corsOrigin: (process.env.CORS_ORIGIN || '').split(',').map(s => s.trim()).filter(Boolean),
    // Where the built frontend lives. If present, the backend will serve it as an SPA.
    // Defaults to ../Frontend/dist relative to the Backend directory when not set.
    frontendDistDir: (process.env.FRONTEND_DIST_DIR || '').trim(),
};
